
package com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;


/**
 * This class was generated by the DNS    RI.
 * DNS    RI 2.2.4-b01
 * Generated source version: 2.2
 * 
 */
@WebService(name = "SchedulingSvcHttpPost", targetNamespace = "http://DNS        /SchedulingSvc")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
    ObjectFactory.class
})
public interface SchedulingSvcHttpPost {


    /**
     * Get all possible cancellation reasons for the logged-in site
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedCancellationReasonsArray
     */
    @WebMethod
    @WebResult(name = "TaggedCancellationReasonsArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedCancellationReasonsArray getCancellationReasons();

    /**
     * Get all possible cancellation reasons for the logged-in site
     * 
     * @param multiSite
     * @param siteId
     * @param mpiPid
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedCancellationReasonsArray
     */
    @WebMethod
    @WebResult(name = "TaggedCancellationReasonsArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedCancellationReasonsArray getVeteranCancellationReasons(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "siteId")
        String siteId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "mpiPid")
        String mpiPid,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "multiSite")
        String multiSite);

    /**
     * Check logged in user's access to clinic
     * 
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.BoolTO
     */
    @WebMethod
    @WebResult(name = "BoolTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public BoolTO hasClinicAccess(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "clinicId")
        String clinicId);

    /**
     * Get list of clinics
     * 
     * @param target
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedHospitalLocationArray
     */
    @WebMethod
    @WebResult(name = "TaggedHospitalLocationArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedHospitalLocationArray getClinics(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "target")
        String target);

    /**
     * Get list of appointment types
     * 
     * @param target
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AppointmentTypeArray
     */
    @WebMethod
    @WebResult(name = "AppointmentTypeArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public AppointmentTypeArray getAppointmentTypes(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "target")
        String target);

    /**
     * Make an appointment for a patient
     * 
     * @param desiredDateTime
     * @param ekg
     * @param lvl
     * @param purposeSubcategory
     * @param bookNotes
     * @param appointmentTimestamp
     * @param appointmentLength
     * @param purpose
     * @param xRay
     * @param lab
     * @param appointmentType
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AppointmentTO
     */
    @WebMethod
    @WebResult(name = "AppointmentTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public AppointmentTO makeAppointment(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "clinicId")
        String clinicId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "appointmentTimestamp")
        String appointmentTimestamp,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "purpose")
        String purpose,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "purposeSubcategory")
        String purposeSubcategory,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "appointmentLength")
        String appointmentLength,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "appointmentType")
        String appointmentType,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "bookNotes")
        String bookNotes,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "Lab")
        String lab,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "XRay")
        String xRay,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "EKG")
        String ekg,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "Lvl")
        String lvl,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "desiredDateTime")
        String desiredDateTime);

    /**
     * Veteran can make a appointment
     * 
     * @param ekg
     * @param multiSite
     * @param mpiPid
     * @param appointmentLength
     * @param purpose
     * @param xRay
     * @param lab
     * @param desiredDateTime
     * @param lvl
     * @param purposeSubcategory
     * @param siteId
     * @param appointmentTimestamp
     * @param bookNotes
     * @param appointmentType
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AppointmentTO
     */
    @WebMethod
    @WebResult(name = "AppointmentTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public AppointmentTO makeVeteranAppointment(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "siteId")
        String siteId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "mpiPid")
        String mpiPid,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "multiSite")
        String multiSite,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "clinicId")
        String clinicId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "appointmentTimestamp")
        String appointmentTimestamp,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "purpose")
        String purpose,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "purposeSubcategory")
        String purposeSubcategory,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "appointmentLength")
        String appointmentLength,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "appointmentType")
        String appointmentType,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "bookNotes")
        String bookNotes,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "Lab")
        String lab,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "XRay")
        String xRay,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "EKG")
        String ekg,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "Lvl")
        String lvl,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "desiredDateTime")
        String desiredDateTime);

    /**
     * Get a list of patients by clinic
     * 
     * @param startDate
     * @param stopDate
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.PatientArray
     */
    @WebMethod
    @WebResult(name = "PatientArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public PatientArray getPatientsByClinic(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "clinicId")
        String clinicId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "startDate")
        String startDate,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "stopDate")
        String stopDate);

    /**
     * Get Electronic Wait List (EWL) by Patient
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedEwlStatusArrays
     */
    @WebMethod
    @WebResult(name = "TaggedEwlStatusArrays", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedEwlStatusArrays getEwlByPatient();

    /**
     * Get Near list by Facility
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedNearListByFacilityArrays
     */
    @WebMethod
    @WebResult(name = "TaggedNearListByFacilityArrays", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedNearListByFacilityArrays getNearListByFacility();

    /**
     * Get Near list by Patient
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedNearListByPatientArrays
     */
    @WebMethod
    @WebResult(name = "TaggedNearListByPatientArrays", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedNearListByPatientArrays getNearListByPatient();

    /**
     * Get Recall List by Facility
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedRecallListByFacilityArrays
     */
    @WebMethod
    @WebResult(name = "TaggedRecallListByFacilityArrays", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedRecallListByFacilityArrays getRecallListByFacility();

    /**
     * Get Electronic Wait List (EWL) by Facility
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedEwlByFacilityArrays
     */
    @WebMethod
    @WebResult(name = "TaggedEwlByFacilityArrays", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedEwlByFacilityArrays getEwlByFacility();

    /**
     * Cancel an appointment for a patient
     * 
     * @param appointmentTimestamp
     * @param cancelreason
     * @param remarks
     * @param cancelCode
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.CancelAppointmentTO
     */
    @WebMethod
    @WebResult(name = "CancelAppointmentTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public CancelAppointmentTO cancelAppointment(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "clinicId")
        String clinicId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "appointmentTimestamp")
        String appointmentTimestamp,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "cancelCode")
        String cancelCode,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "cancelreason")
        String cancelreason,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "remarks")
        String remarks);

    /**
     * Cancel veteran's appointment
     * 
     * @param appointmentTimestamp
     * @param multiSite
     * @param siteId
     * @param mpiPid
     * @param cancelreason
     * @param remarks
     * @param cancelCode
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.CancelAppointmentTO
     */
    @WebMethod
    @WebResult(name = "CancelAppointmentTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public CancelAppointmentTO cancelVeteranAppointment(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "siteId")
        String siteId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "mpiPid")
        String mpiPid,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "multiSite")
        String multiSite,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "clinicId")
        String clinicId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "appointmentTimestamp")
        String appointmentTimestamp,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "cancelCode")
        String cancelCode,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "cancelreason")
        String cancelreason,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "remarks")
        String remarks);

    /**
     * Get a patient's pending appointments with booking notes.
     * 
     * @param fromDate
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedAppointmentArray
     */
    @WebMethod
    @WebResult(name = "TaggedAppointmentArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedAppointmentArray getAppointmentsBookingNotes(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "fromDate")
        String fromDate);

    /**
     * Get veteran's pending appointments with booking notes.
     * 
     * @param fromDate
     * @param multiSite
     * @param siteId
     * @param mpiPid
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedAppointmentArray
     */
    @WebMethod
    @WebResult(name = "TaggedAppointmentArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedAppointmentArray getVeteranAppointmentsBookingNotes(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "siteId")
        String siteId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "mpiPid")
        String mpiPid,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "multiSite")
        String multiSite,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "fromDate")
        String fromDate);

    /**
     * Get clinic scheduling information, e.g., availability, default appointment length, etc.<br />clinicId is required. startDate and endDate are optional.<br />If dates are used, they should be in the form yyyymmdd.hhmmss (.hhmmss may be omitted if not needed).
     * 
     * @param startDate
     * @param endDate
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedHospitalLocationArray
     */
    @WebMethod
    @WebResult(name = "TaggedHospitalLocationArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedHospitalLocationArray getClinicSchedulingDetailsByDateRange(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "clinicId")
        String clinicId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "startDate")
        String startDate,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "endDate")
        String endDate);

    /**
     * Get clinic scheduling information, e.g., availability, default appointment length, etc.<br />clinicId is required. startDate and endDate are optional.<br />If dates are used, they should be in the form yyyymmdd.hhmmss (.hhmmss may be omitted if not needed).
     * 
     * @param startDate
     * @param multiSite
     * @param siteId
     * @param mpiPid
     * @param endDate
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedHospitalLocationArray
     */
    @WebMethod
    @WebResult(name = "TaggedHospitalLocationArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedHospitalLocationArray getVeteranClinicSchedulingDetailsByDateRange(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "siteId")
        String siteId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "mpiPid")
        String mpiPid,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "multiSite")
        String multiSite,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "clinicId")
        String clinicId,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "startDate")
        String startDate,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "endDate")
        String endDate);

    /**
     * Get all clinics for the logged-in site, including specialties
     * 
     * @param target
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedHospitalLocationArray
     */
    @WebMethod
    @WebResult(name = "TaggedHospitalLocationArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedHospitalLocationArray getClinicsWithSpecialties(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "target")
        String target);

    /**
     * Get Recall list by Patient
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedRecallListByPatientArrays
     */
    @WebMethod
    @WebResult(name = "TaggedRecallListByPatientArrays", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedRecallListByPatientArrays getRecallListByPatient();

    /**
     * Remove Patient from Electronic Waiting List (EWL)
     * 
     * @param sdwlData
     * @param disp
     * @param sdwlien
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TextTO
     */
    @WebMethod
    @WebResult(name = "TextTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TextTO removePatientFromEwl(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "SDWLIEN")
        String sdwlien,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "Disp")
        String disp,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "SDWLData")
        String sdwlData);

    /**
     * Update Near List
     * 
     * @param status
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedUpdateNearListArrays
     */
    @WebMethod
    @WebResult(name = "TaggedUpdateNearListArrays", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedUpdateNearListArrays updateNearList(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "Status")
        String status);

    /**
     * Add patient to Electronic Wait List (EWL)
     * 
     * @param enrolleeDateUsed
     * @param enrolleeDatabaseFile
     * @param waitListType
     * @param enrolleeStatus
     * @param desiredApptDate
     * @param provider
     * @param priority
     * @param changedClinicParentPointer
     * @param pointer
     * @param svcConnectedPriority
     * @param comment
     * @param schedulingReminderFlag
     * @param institution
     * @param requestedBy
     * @param svcConnectedPct
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TextTO
     */
    @WebMethod
    @WebResult(name = "TextTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TextTO addPatientToEwl(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "waitListType")
        String waitListType,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "institution")
        String institution,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "pointer")
        String pointer,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "priority")
        String priority,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "requestedBy")
        String requestedBy,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "provider")
        String provider,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "svcConnectedPct")
        String svcConnectedPct,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "svcConnectedPriority")
        String svcConnectedPriority,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "desiredApptDate")
        String desiredApptDate,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "comment")
        String comment,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "enrolleeStatus")
        String enrolleeStatus,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "enrolleeDateUsed")
        String enrolleeDateUsed,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "enrolleeDatabaseFile")
        String enrolleeDatabaseFile,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "schedulingReminderFlag")
        String schedulingReminderFlag,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "changedClinicParentPointer")
        String changedClinicParentPointer);

    /**
     * Get all possible consult statuses
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedConsultStatusesArray
     */
    @WebMethod
    @WebResult(name = "TaggedConsultStatusesArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedConsultStatusesArray getConsultStatuses();

    /**
     * Get all possible consulting services
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedConsultingServicesArray
     */
    @WebMethod
    @WebResult(name = "TaggedConsultingServicesArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedConsultingServicesArray getConsultingServices();

    /**
     * Get consults by a combination of service, provider, and status
     * 
     * @param startDate
     * @param service
     * @param provider
     * @param endDate
     * @param statuses
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedConsultsArray
     */
    @WebMethod
    @WebResult(name = "TaggedConsultsArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedConsultsArray getConsultsWithoutPatient(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "startDate")
        String startDate,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "endDate")
        String endDate,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "service")
        String service,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "statuses")
        String statuses,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "provider")
        String provider);

    /**
     * Get detailed report for a particular consult
     * 
     * @param consultIen
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedConsultDetailArray
     */
    @WebMethod
    @WebResult(name = "TaggedConsultDetailArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedConsultDetailArray getConsultDetails(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "consultIen")
        String consultIen);

    /**
     * Add a data source for this session
     * 
     * @param region
     * @param port
     * @param id
     * @param protocol
     * @param name
     * @param modality
     * @param datasource
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SiteTO
     */
    @WebMethod
    @WebResult(name = "SiteTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public SiteTO addDataSource(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "id")
        String id,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "name")
        String name,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "datasource")
        String datasource,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "port")
        String port,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "modality")
        String modality,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "protocol")
        String protocol,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "region")
        String region);

    /**
     * Set the current session's sites file
     * 
     * @param sitesFileName
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SiteArray
     */
    @WebMethod
    @WebResult(name = "SiteArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public SiteArray setVha(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "sitesFileName")
        String sitesFileName);

    /**
     * Get all VHA sites
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.RegionArray
     */
    @WebMethod
    @WebResult(name = "RegionArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public RegionArray getVHA();

    /**
     * Connect to a single VistA system
     * 
     * @param sitelist
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.DataSourceArray
     */
    @WebMethod
    @WebResult(name = "DataSourceArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public DataSourceArray connect(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "sitelist")
        String sitelist);

    /**
     * Log onto a single VistA system
     * 
     * @param pwd
     * @param username
     * @param context
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.UserTO
     */
    @WebMethod
    @WebResult(name = "UserTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public UserTO login(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "username")
        String username,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "pwd")
        String pwd,
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "context")
        String context);

    /**
     * Disconnect from all connected Vista systems.
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedTextArray
     */
    @WebMethod
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public TaggedTextArray disconnect();

    /**
     * Select a patient at logged in site. DFN is the Patient's IEN.
     * 
     * @param dfn
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.PatientTO
     */
    @WebMethod
    @WebResult(name = "PatientTO", targetNamespace = "http://DNS        /SchedulingSvc", partName = "Body")
    public PatientTO select(
        @WebParam(name = "string", targetNamespace = "http://www.w3.org/2001/XMLSchema", partName = "DFN")
        String dfn);

}
